/**
 * i-net software provides programming examples for illustration only, without warranty
 * either expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and/or fitness for a particular purpose. This programming example
 * assumes that you are familiar with the programming language being demonstrated and
 * the tools used to create and debug procedures. i-net software support professionals
 * can help explain the functionality of a particular procedure, but they will not modify
 * these examples to provide added functionality or construct procedures to meet your
 * specific needs.
 *
 * Copyright © 1999-2025 i-net software GmbH, Berlin, Germany.
**/
package rdc;

import java.net.URL;

import com.inet.report.Engine;
import com.inet.report.Field;
import com.inet.report.Fields;
import com.inet.report.PromptField;

/**
 * This example show you how to use prompt fields with the api.
 */

public class PromptsSample extends RDCSample {

    //change this before running the example if the location of the report
    //"mainrep.rpt" which comes with the rdc samples has changed
    static private final String MAINREPORT = "samples/rdc/mainrep.rpt";

    /**
     * Add parameter fields to an existing report.
     * @param exportFmt the output format (e.g. Engine.EXPORT_PDF)
     * @return the new engine for the report
     */
    @Override
    public Engine createAndFillEngine( String exportFmt ) {
        try {
            //create a new Engine
            Engine eng = new Engine( exportFmt );
            //set the name of the report file, that contain
            URL reportURL = getClass().getResource( '/' + MAINREPORT );
            if( reportURL != null ) {
                eng.setReportFile( reportURL );
            } else {
                eng.setReportFile( MAINREPORT );
            }

            Fields fields = eng.getFields();

            PromptField pField = null;
            //add a prompt field to fields set
            pField = fields.addPromptField( "promptSF", "Enter a number between 12310 and 41239", Field.NUMBER );
            //allow more than one value
            pField.setAllowMultipleValues( true );
            //allow discrete and range values
            pField.setDiscreteOrRangeType( PromptField.DISCRETE_AND_RANGE_VALUE );
            //set the prompt as value range
            pField.setUseRange( true );
            pField.setMinMaxRangeValues( 12310, 41239 );

            //set the values of the prompts
            //Object[] values = new Object[4];
            //values[1] = new Long(3);
            //values[2] = new Long(5);
            //values[0] = new FormulaRange(new Double(2), new Double(10));
            //values[3] = new FormulaRange(new Long(20), new Long(30));
            //pField.setPromptValue(values);

            //another way is to set the value of the prompt with a formula, like this
            //pField.setPromptValueAsFormula("[2,6]");

            //try this, too
            //pField.setPromptValueAsFormula("2");

            //do something with the prompt, i.e. set the selection formula using a prompt
            eng.setSF( "{Customers.CustomerID} in {?promptSF}" );

            return eng;
        } catch( Throwable e ) {
            e.printStackTrace();
            System.exit( 0 );
            return null;
        }
    }

    /**
     * Main method of this sample
     * @param args arguments not used
     */
    public static void main( String[] args ) {
        new PromptsSample().initUI();
    }
}
